import java.util.Scanner;

// Listing 13-7

public class Listing13_7
{
   public static void main(String [] args)
   {
      // Deklarujemy tablicę zawierającą identyfikatory pracowników
      int numbers[] = {101, 142, 147, 189, 199, 207, 222,
                       234, 289, 296, 310, 319, 388, 394,
                       417, 429, 447, 521, 536, 600};
      
      // Deklarujemy zmienną, w której zapiszemy identyfikator pracownika
      int empID;
      
      // Deklarujemy zmienną, w której zapiszemy wynik wyszukiwania
      int results;

      // Tworzymy obiekt Scanner, aby odczytać dane wprowadzone na klawiaturze
      Scanner keyboard = new Scanner(System.in);

      // Pobieramy identyfikator szukanego pracownika
      System.out.print("Wprowadź identyfikator pracownika.");
      empID = keyboard.nextInt();

      // Wyszukujemy identyfikator w tablicy
      results = binarySearch(numbers, 0, (numbers.length - 1), empID);

      // Wyświetlamy wynik wyszukiwania
      if (results == -1)
      {
         System.out.println("Nie udało się wyszukać pracownika o takim identyfikatorze.");
      }
      else
      {
         System.out.println("Znaleziono pracownika o takim identyfikatorze " +
                            "przy indeksie " + results);
      }
   }

   // Metoda binarySearch wykonuje rekurencyjne wyszukiwanie binarne
   // we wskazanym fragmencie tablicy. Parametr array
   // to przeszukiwana tablica. Parametr first
   // to indeks pierwszego elementu przeszukiwanego fragmentu,
   // a parametr last to indeks ostatniego elementu przeszukiwanego fragmentu.
   // Parametr value to szukana wartość. Gdy wartość zostanie odnaleziona,
   // metoda zwraca indeks szukanego elementu. W przeciwnym razie
   // metoda zwraca wartość –1
   public static int binarySearch(int[] array, int first, int last, int value)
   {
      int middle;      // Indeks środkowego elementu przeszukiwanego fragmentu tablicy

        
      // Sparawdzamy przypadek bazowy,
      // gdy wartości nie udało się odszukać
      if (first > last)
         return -1;
        
      // Obliczamy indeks środkowego elementu przeszukiwanego fragmentu tablicy
      middle = (first + last) / 2;
       
      // Szukamy wartości
      if (array[middle] == value)
         return middle;
      else if (array[middle] < value)
         return binarySearch(array, middle + 1,
                             last, value);
      else
         return binarySearch(array, first,
                             middle - 1, value);
   }
}